;;; -*- Mode:Common-Lisp; Package:MACTOOLBOX; Base:10; Fonts:(CPTFONT HL10B HL12I CPTFONT CPTFONTB); Patch-File:t -*-

;;;			    RESTRICTED RIGHTS LEGEND
;;; Use, duplication, or disclosure by the Government is subject to restrictions as
;;; set forth in subdivision (c)(1)(ii) of the Rights in Technical Data and 
;;; Computer Software clause at 52.227-7013.
;;; 	 TEXAS INSTRUMENTS INCORPORATED, P.O. BOX 2909, AUSTIN, TEXAS 78769
;;;      Copyright (C) 1989 Texas Instruments Incorporated.  All rights reserved.


;1;; Loading this patch file redefines a number of trap functions as inline functions which are much faster*
;1;; than the original versions.*

;1;; All Macintosh Toolbox traps nominally execute in the Macintosh OS.  However, a few of these defined*
;1;; traps are trivial (e.g., ANDing to integers) and are therefore independent of any hardware or OS.  Also,*
;1;; a few of the non-trivial ones use and modify only application-specific data structures--data structures*
;1;; which are not need on the Macintosh side for anything else.  Therefore, these data structures might*
;1;; just as well reside on the microExplorer side.*
;1;;*
;1;; The traps which uses these microExplorer-side data strucutres still execute on the Macintosh side so*
;1;; that the execution sequence looks something like this starting with a call to the trap:*
;1;;*
;1;;*	1*  Tear the microExplorer data strucuture down into it components and individually stuff them*
;1;;                  into a microNet packet along with other arguments.*
;1;;*	1*  Relay that packet to the Macintosh side.*
;1;;*	1*  Reassemble the individual packet contents into a suitable Macintosh data structure.*
;1;;*	1*  Call the Macintosh trap who merely modifies this data structure often does little more than*
;1;;                 stuff some of the other arguments that came in the packet into the structure.*
;1;;*	1*  Tear the modified Macintosh structure down into its components and individually stuff them*
;1;;                  into a microNet package for the return trip.*
;1;;*	1*  Relay that return packet back to the microExplorer side.*
;1;;*	1*  Reassemble the individual return packet contents into a newly consed microExplorer data*
;1;;                 structure.*
;1;;*
;1;; The functions in this file offer a better way.*


;1;;; 4POINT*s*
(proclaim '(inline !AddPt))
(defun 4!AddPt *(3srcPoint* 3dstPoint*)
  (declare (arglist |3srcPoint|* |3dstPoint|*))
  (send 3dstPoint* :add 3srcPoint*))
(remprop '!AddPt 'compiler:style-checker)

(proclaim '(inline !EqualPt))
(defun 4!EqualPt *(3ptA* 3ptB*)
  (declare (arglist |3ptA|* |3ptB|*))
  (send 3ptA* :equal 3ptB*))
(remprop '!EqualPt 'compiler:style-checker)

(proclaim '(inline !MapPt))
(defun 4!MapPt *(point srcRect dstRect)
  (declare (arglist |point3|* |srcRect3|* |dstRect3|*))
  (send point :map srcRect dstRect))
(remprop '!MapPt 'compiler:style-checker)

(proclaim '(inline !ScalePt))
(defun 4!ScalePt *(point srcRect dstRect)
  (declare (arglist |point3|* |srcRect3|* |dstRect3|*))
  (send point :scale srcRect dstRect))
(remprop '!ScalePt 'compiler:style-checker)

(proclaim '(inline !SetPt))
(defun 4!SetPt *(3point* 3h* 3v*)
  (declare (arglist |3point|* |3h|* |3v|*))
  (send 3point* :set 3h* 3v*))
(remprop '!SetPt 'compiler:style-checker)

(proclaim '(inline !SubPt))
(defun 4!SubPt *(3srcPoint* 3dstPoint*)
  (declare (arglist |3srcPoint|* |3dstPoint|*))
  (send 3dstPoint* :sub 3srcPoint*))
(remprop '!SubPt 'compiler:style-checker)


;1;;; 4RECT*s*
(proclaim '(inline !EmptyRect))
(defun 4!EmptyRect *(rect)
  (declare (arglist |3rect|*))
  (send rect :empty-p))
(remprop '!EmptyRect 'compiler:style-checker)

(proclaim '(inline !EqualRect))
(defun 4!EqualRect *(rectA rectB)
  (declare (arglist |3rectA|* |3rectB|*))
  (send rectA :equal rectB))
(remprop '!EqualRect 'compiler:style-checker)

(proclaim '(inline !InsetRect))
(defun 4!InsetRect *(rect dh dv)
  (declare (arglist |3rect|* |3dh|* |3dv|*))
  (send rect :inset dh dv))
(remprop '!InsetRect 'compiler:style-checker)

(proclaim '(inline !MapRect))
(defun 4!MapRect *(resultRect srcRect dstRect)
  (declare (arglist |3resultRect|* |srcRect3|* |dstRect3|*))
  (send resultRect :map srcRect dstRect))
(remprop '!MapRect 'compiler:style-checker)

(proclaim '(inline !OffsetRect))
(defun 4!OffsetRect *(rect dh dv)
  (declare (arglist |3rect|* |3dh|* |3dv|*))
  (send rect :offset dh dv))
(remprop '!OffsetRect 'compiler:style-checker)

(proclaim '(inline !PtInRect))
(defun 4!PtInRect *(point rect)
  (declare (arglist |3point|* |3rect|*))
  (send rect :inside-p point))
(remprop '!PtInRect 'compiler:style-checker)

(proclaim '(inline !Pt2Rect))
(defun 4!Pt2Rect *(ptA ptB rect)
  (declare (arglist |3ptA|* |3ptB|* |3rect|*))
  (send rect :set ptA ptB))
(remprop '!Pt2Rect 'compiler:style-checker)
  
(proclaim '(inline !SetRect))
(defun 4!SetRect *(rect left top right bottom)
  (declare (arglist |rect3|* |left3|* |top3|* |right3|* |bottom3|*))
  (send rect :set top left bottom right))
(remprop '!SetRect 'compiler:style-checker)



;1;;; 4BIT Functions**
(proclaim '(inline !BitAnd))
(defun 4!BitAnd *(value1 value2)
  (declare (arglist |3value1|* |3value2|*))
  (logand value1 value2 #xFFFFFFFF))
(remprop '!BitAnd 'compiler:style-checker)

(proclaim '(inline !BitOr))
(defun 4!BitOr *(value1 value2)
  (declare (arglist |3value1|* |3value2|*))
  (logand #xFFFFFFFF (logior value1 value2)))
(remprop '!BitOr 'compiler:style-checker)

(proclaim '(inline !BitXor))
(defun 4!BitXor *(value1 value2)
  (declare (arglist |3value1|* |3value2|*))
  (logand #xFFFFFFFF (logxor value1 value2)))
(remprop '!BitXor 'compiler:style-checker)

(proclaim '(inline !BitNot))
(defun 4!BitNot *(value)
  (declare (arglist |3value|*))
  (logand #xFFFFFFFF (lognot value)))
(remprop '!BitNot 'compiler:style-checker)

(proclaim '(inline !BitShift))
(defun 4!BitShift *(value count)
  (declare (arglist |3value|* |3count|*))
  (logand #xFFFFFFFF (ash (logand #xFFFFFFFF value) count)))
(remprop '!BitShift 'compiler:style-checker)